﻿var oEditor		= window.parent.InnerDialogLoaded() ;
var FCK			= oEditor.FCK ;
var FCKLang		= oEditor.FCKLang ;
var FCKConfig	= oEditor.FCKConfig ;

window.parent.AddTab( 'Info', oEditor.FCKLang.DlgInfoTab ) ;
if ( FCKConfig.MediaBrowser )
    window.parent.AddTab( 'Browser', oEditor.FCKLang.DlgBtnBrowseServer ) ;
if ( FCKConfig.MediaUpload )
    window.parent.AddTab( 'Upload', FCKLang.DlgLnkUpload ) ;

function OnDialogTabChange( tabCode )
{
	ShowE('divInfo'		, ( tabCode == 'Info' ) ) ;
	ShowE('divBrowser'	, ( tabCode == 'Browser' ) ) ;
	ShowE('divUpload'	, ( tabCode == 'Upload' ) ) ;

	if(tabCode == 'Browser') { BrowserServer(1); }
}

function BrowserServer(pg) {
	GetE('attachList').innerHTML = LoadUrl( FCKConfig.MediaBrowserURL + "&idx=" + pg ) ;
}

function HidePic() {}
function ShowPic(div,url) {}
function ElePosT(s) {}
function ElePosL(s) {}

var oFakeImage = FCK.Selection.GetSelectedElement() ;
var oEmbed ;

if ( oFakeImage )
{
	if ( oFakeImage.tagName == 'IMG' && oFakeImage.className == 'FCK__Media')
		oEmbed = FCK.GetRealElement( oFakeImage ) ;
	else
		oFakeImage = null ;
}

window.onload = function()
{
	oEditor.FCKLanguageManager.TranslatePage(document) ;
	LoadSelection() ;
	if ( FCKConfig.MediaUpload )
	    GetE('frmUpload').action = FCKConfig.MediaUploadURL ;
	window.parent.SetAutoSize( true ) ;
	window.parent.SetOkButton( true ) ;
}

var oEmbedOriginal;

function LoadSelection()
{
	if ( ! oEmbed ) {
		GetE('txtAttId').value = "M_" + parseInt(Math.random()*799);
		return ;
	}
	var oFakeA = oEmbed.getElementsByTagName("A")[0];
	eval("var oFakeC = " + oFakeA.className);
	oEmbedOriginal = {
		id : oFakeA.id,
		src : GetAttribute( oFakeA, 'href', ''),
		title : GetAttribute( oFakeA, 'title', ''),
		width : (oFakeC.width) ? oFakeC.width : 280,
		height : (oFakeC.height) ? oFakeC.height : 60,
		play : (oFakeC.play) ? oFakeC.play : false,
		loop: (oFakeC.loop) ? oFakeC.loop : false
	} ;
	GetE('txtAttId').value	= oEmbedOriginal.id ;
	GetE('txtUrl').value	= oEmbedOriginal.src ;
	GetE('txtAttTitle').value	= oEmbedOriginal.title ;
	GetE('txtWidth').value	= oEmbedOriginal.width ;
	GetE('txtHeight').value	= oEmbedOriginal.height ;
	GetE('chkAutoPlay').checked	= oEmbedOriginal.play ;
	GetE('chkLoop').checked	= oEmbedOriginal.loop ;

	UpdatePreview() ;
}

var bLockRatio = true ;

function SwitchLock( lockButton )
{
	bLockRatio = !bLockRatio ;
	lockButton.className = bLockRatio ? 'BtnLocked' : 'BtnUnlocked' ;
	lockButton.title = bLockRatio ? 'Lock sizes' : 'Unlock sizes' ;

	if ( bLockRatio )
	{
		if ( GetE('txtWidth').value.length > 0 )
			OnSizeChanged( 'Width', GetE('txtWidth').value ) ;
		else
			OnSizeChanged( 'Height', GetE('txtHeight').value ) ;
	}
}

// Fired when the width or height input texts change
function OnSizeChanged( dimension, value )
{
	// Verifies if the aspect ration has to be mantained
	if ( oEmbedOriginal && bLockRatio )
	{
		var e = dimension == 'Width' ? GetE('txtHeight') : GetE('txtWidth') ;

		if ( value.length == 0 || isNaN( value ) )
		{
			e.value = '' ;
			return ;
		}

		if ( dimension == 'Width' )
			value = value == 0 ? 0 : Math.round( oEmbedOriginal.height * ( value  / oEmbedOriginal.width ) ) ;
		else
			value = value == 0 ? 0 : Math.round( oEmbedOriginal.width  * ( value / oEmbedOriginal.height ) ) ;

		if ( !isNaN( value ) )
			e.value = value ;
	}

	UpdatePreview() ;
}

function ResetSizes()
{
	if ( ! oEmbedOriginal ) return ;

	GetE('txtWidth').value  = oEmbedOriginal.width ;
	GetE('txtHeight').value = oEmbedOriginal.height ;

	UpdatePreview() ;
}

function Ok()
{
	if ( GetE('txtUrl').value.length == 0 )
	{
		window.parent.SetSelectedTab( 'Info' ) ;
		GetE('txtUrl').focus() ;

		alert( oEditor.FCKLang.DlgAlertUrl ) ;

		return false ;
	}
	if ( oEmbed == null )
		oEmbed = FCK.CreateElement( 'EMBED' ) ;
	else
		oEditor.FCKUndo.SaveUndoStep() ;
	UpdateEmbed(oEmbed);
	return true ;
}

function UpdateEmbed(oEmbed)
{
	var sUrl = GetE('txtUrl').value;
	if(GetFileExt(sUrl) == 'mp3') {
		sUrl = FCKConfig.BasePath + "Player.swf?soundFile=" + encodeURIComponent(sUrl)+"&t=swf";
		SetAttribute( oEmbed, 'src',sUrl ) ;
		SetAttribute( oEmbed, "width" , '290' ) ;
		SetAttribute( oEmbed, "height", '24' ) ;
	} else {
		SetAttribute( oEmbed, 'src',sUrl ) ;
		SetAttribute( oEmbed, "width" , '450' ) ;
		SetAttribute( oEmbed, "height", '320' ) ;
	}
	SetAttribute( oEmbed, 'type', 'application/x-shockwave-flash' ) ;
	SetAttribute( oEmbed, 'pluginspage'	, 'http://www.macromedia.com/go/getflashplayer' ) ;
	SetAttribute( oEmbed, 'wmode', 'transparent' ) ;
	SetAttribute( oEmbed, 'menu', 'false' ) ;
	SetAttribute( oEmbed, 'play', GetE('chkAutoPlay').checked ? 'true' : 'false' ) ;
	SetAttribute( oEmbed, 'loop', GetE('chkLoop').checked ? 'true' : 'false' ) ;
}

var ePreview ;

function SetPreviewElement( previewEl )
{
	ePreview = previewEl ;

	if ( GetE('txtUrl').value.length > 0 )
		UpdatePreview() ;
}

function UpdatePreview()
{
	if ( !ePreview )
		return ;

	while ( ePreview.firstChild )
		ePreview.removeChild( ePreview.firstChild ) ;

	if ( GetE('txtUrl').value.length == 0 )
		ePreview.innerHTML = '&nbsp;' ;
	else
	{
		var oDoc	= ePreview.ownerDocument || ePreview.document ;
		var e		= oDoc.createElement( 'EMBED' ) ;

		UpdateEmbed(e);

		ePreview.appendChild( e ) ;
	}
}

function SetUrl( url, width, height )
{
	GetE('txtUrl').value = url ;

	if ( width )
		GetE('txtWidth').value = width ;

	if ( height )
		GetE('txtHeight').value = height ;

	UpdatePreview() ;

	window.parent.SetSelectedTab( 'Info' ) ;
}

function OnUploadCompleted( errorNumber, fileUrl, fileName, customMsg )
{
	switch ( errorNumber )
	{
		case 0 :	// No errors
			alert( 'Your file has been successfully uploaded' ) ;
			break ;
		case 1 :	// Custom error
			alert( customMsg ) ;
			return ;
		case 101 :	// Custom warning
			alert( customMsg ) ;
			break ;
		case 201 :
			alert( 'A file with the same name is already available. The uploaded file has been renamed to "' + fileName + '"' ) ;
			break ;
		case 202 :
			alert( 'Invalid file type' ) ;
			return ;
		case 203 :
			alert( "Security error. You probably don't have enough permissions to upload. Please check your server." ) ;
			return ;
		default :
			alert( 'Error on file upload. Error number: ' + errorNumber ) ;
			return ;
	}

	SetUrl( fileUrl ) ;
	GetE('frmUpload').reset() ;
}

var oUploadAllowedExtRegex	= new RegExp( FCKConfig.MediaUploadAllowedExtensions, 'i' ) ;
var oUploadDeniedExtRegex	= new RegExp( FCKConfig.MediaUploadDeniedExtensions, 'i' ) ;

function CheckUpload()
{
	var sFile = GetE('txtUploadFile').value ;

	if ( sFile.length == 0 )
	{
		alert( 'Please select a file to upload' ) ;
		return false ;
	}

	if ( FCKConfig.MediaUploadAllowedExtensions.length > 0 && !oUploadAllowedExtRegex.test( sFile ) )
	{
		OnUploadCompleted( 202 ) ;
		return false ;
	}

	return true ;
}

function GetFileExt(fileUrl)
{
	var rex = /^((\w+):\/\/)?((\w+):?(\w+)?@)?([^\/\?:]+):?(\d+)?(\/?[^\?#]+)?\??([^#]+)?#?(\w*)/;
	var filePath = rex.exec(fileUrl)[8].split(".");
	return filePath[filePath.length-1].toLowerCase();
}